SET DEADLOCK_PRIORITY HIGH;
IF NOT EXISTS (SELECT 1 FROM SYS.COLUMNS WHERE NAME ='CD_CTR' AND OBJECT_ID = OBJECT_ID ('RC_CLI_ESTATIS_PENDENTE'))
begin 
    ALTER TABLE RC_CLI_ESTATIS_PENDENTE ADD CD_CTR INT IDENTITY(1, 1) NOT NULL;
end
go
DECLARE @PK VARCHAR(50),@SCRIPT VARCHAR(8000);
SET @PK=(
    SELECT TOP 1 I.NAME
    FROM SYS.INDEXES I
         INNER JOIN SYS.INDEX_COLUMNS IC ON IC.OBJECT_ID = I.OBJECT_ID
                                            AND IC.INDEX_ID = I.INDEX_ID
         INNER JOIN SYS.COLUMNS C ON C.OBJECT_ID = IC.OBJECT_ID
                                     AND C.COLUMN_ID = IC.COLUMN_ID
    WHERE I.OBJECT_ID = OBJECT_ID('RC_CLI_ESTATIS_PENDENTE')
          AND C.NAME <> 'CD_CTR'
          AND I.IS_PRIMARY_KEY = 1)

IF @PK IS NOT NULL
    BEGIN
        SET @SCRIPT = 'ALTER TABLE RC_CLI_ESTATIS_PENDENTE DROP CONSTRAINT '+@PK;
        EXEC (@SCRIPT);
        ALTER TABLE RC_CLI_ESTATIS_PENDENTE ADD CONSTRAINT PK_RC_CLI_ESTATIS_PENDENTE PRIMARY KEY(CD_CTR);
    END
else if not exists (SELECT 1 FROM SYS.INDEXES WHERE OBJECT_ID = OBJECT_ID('RC_CLI_ESTATIS_PENDENTE') AND IS_PRIMARY_KEY = 1)
    begin 
	   ALTER TABLE RC_CLI_ESTATIS_PENDENTE ADD CONSTRAINT PK_RC_CLI_ESTATIS_PENDENTE PRIMARY KEY(CD_CTR);
    end